package gov.va.med.mhv.journal.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name = "FOOD_JOURNALS")
public class FoodJournal implements Serializable {

	private static final long serialVersionUID = -5620838315239618652L;

	@Id
	@Column(name = "FOOD_JOURNAL_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long foodJournalId;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "GLASSES_OF_WATER")
	private BigDecimal glassesOfWater;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "COMMENTS")
	private String comments;

	@Column(name = "FOOD_JOURNAL_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date journalDate;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@OneToMany(mappedBy = "foodJournal", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval=true)
	@Fetch(FetchMode.SELECT)
	private Set<MealItem> mealItems;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userId;

	/*@ManyToOne(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@JoinColumn(name = "USER_PROFILE_USER_PROFILE_ID")
	private UserProfile userProfile;*/

	public Long getFoodJournalId() {
		return foodJournalId;
	}

	public void setFoodJournalId(Long foodJournalId) {
		this.foodJournalId = foodJournalId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public BigDecimal getGlassesOfWater() {
		return glassesOfWater;
	}

	public void setGlassesOfWater(BigDecimal glassesOfWater) {
		this.glassesOfWater = glassesOfWater;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getJournalDate() {
		return journalDate;
	}

	public void setJournalDate(Date journalDate) {
		this.journalDate = journalDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Set<MealItem> getMealItems() {
		return mealItems;
	}

	public void setMealItems(Set<MealItem> mealItems) {
		this.mealItems = mealItems;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	/*public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}*/
	
	public void addMealItem(MealItem mealItem) {
		mealItem.setFoodJournal(this);
        this.mealItems.add(mealItem);
    }
}
